


// globals
var initialx, initialy, scrolltext;
var frame = 0;
var amplitude1 = 50
var offset = 0.2;
var speed = 0.2;
var scrollspeed = 10;
var charwidth = 70;

var twopi = Math.PI * 2;
var chracters, position, numvisible, nextchar, firstchar;
var skipsteps = 1;
var delaytimer = 0;
var interval;
var numvisible = Math.floor(getWidth()/60);

// PROFILER
var stepScrollloop = 100;
var totalTimeScroll = 0;
var avgTimeScroll =0;
var avgTotalScroll = 0;
// END PROFILER

function startScroll ()
{	
	// get all of the DIV tags into an array (IE only?)
	//if (!document.all) return

	characters = document.all.item('character');

	// setup timeout to call this function again
	interval = window.setInterval("stepScroll()", 1);
}

// stop the animation
function stopScroll ()
{
	if (!document.all) return
	if (interval) clearInterval(interval);
}

// function to create sine scroller
function sinescroll (x, y, value, number_of_chars)
{

	// PROFILER
	//startTime = new Date();
	// END PROFILE

	// setup globals
	scrolltext = new String(value);
	initialx = x;
	initialy = y;
	nextchar = numvisible;
	firstchar = 0;

	// create fixed-size arrays of characters and positions
	characters = new Array(numvisible);
	position = initialx;

	// write DIVs to hold characters
	for (var i = 0; i < numvisible; i++)
	{
		document.write('<DIV ID="character" STYLE="position:absolute;top:',
			initialy, ';left:-10000', //(initialx + i * charwidth),
			';width=', charwidth, ';height=30;" ><IMG SRC="chars/char_', scrolltext.charAt(i),'.png"></DIV>');
	}
	
	// PROFILER
	//endTime = new Date();
	//totalTime = endTime-startTime;
	//window.status = "Temps d'execution sinescroll() = " + totalTime + " ms";
	// END PROFILE		
	
}



// animation function
function stepScroll()
{

	// PROFILER
	startTimeScroll = new Date();
	// END PROFILE

	// increment counters
	frame += speed;

	//uncomment to delay the scrolltext if character = '|'
	// delay timer
	/*
	if (delaytimer > 0) delaytimer--;
	else
	*/
	
	position -= scrollspeed;	// update position
		

	// check for 'offscreen'
	if (position < (initialx - charwidth))
	{
		//uncomment to delay the scrolltext if character = '|'
		/*
		while (scrolltext.charAt(nextchar) == '|')
		{
			delaytimer += 90;
			nextchar++;
		}
		*/
		
		// set nextchar into characters array
		characters[firstchar].innerHTML = '<IMG SRC="chars/char_' + scrolltext.charAt(nextchar) + '.png">';

		// update nextchar
		nextchar++;

		// check for wrap-around
		if (nextchar >= scrolltext.length)
		{
			nextchar = 0;
		}

		// change position and counters by offset
		position += charwidth;
		frame += offset;

		// update firstchar
		firstchar++;

		if (firstchar >= numvisible)
		{
			firstchar = 0;
		}
	}

	// wrap-around counters
	if (frame > twopi) frame -= twopi;

	// set up loop variables
	var angle = frame;
	var pos = position;

	// update the html
	for (var i=firstchar; i < numvisible; i++)
	{
		characters[i].style.left = pos;
		characters[i].style.top = initialy + amplitude1 * Math.sin(angle);
		angle += offset;
		pos += charwidth;
		
	}
	
	for (var i=0; i < firstchar; i++)
	{
		characters[i].style.left = pos;
		characters[i].style.top = initialy + amplitude1 * Math.sin(angle);
		angle += offset;
		pos += charwidth;
	}	



	// PROFILER
	stepScrollloop--;
	endTimeScroll = new Date();
	
	totalTimeScroll = totalTimeScroll + (endTimeScroll-startTimeScroll);
	
	if(stepScrollloop == 0){
		avgTimeScroll = avgTimeScroll + totalTimeScroll;
		avgTotalScroll++;
		stepScrollloop = 100;
		window.status = "Temps d'execution " + stepScrollloop + " StepScroll() = " + totalTimeScroll + " ms (avg = " + Math.floor(avgTimeScroll/avgTotalScroll) + " ms)";
		totalTimeScroll = 0;
	}
	// END PROFILE		
	
}




